/*
Programm par Maniack Crudelis.
http://www.crudelis.fr.tc
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
*/

#ifndef JDR_H
#define JDR_H

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include "Rand.h"
#include "Fichier.h"
#include "Utilitaire.h"
#include "Chaines.h"

struct info_perso         /*Structure de donnes pour personnage*/
{
    int niveau; /*Niveau du perso*/
    int poids; /*Poids*/
    int taille; /*Taille*/
    char cat_taille[10];    /*Catgorie de taille*/
    int age; /*Age*/
    char alignement[50]; /*Alignement*/
    int attaque[50]; /*Jet d'attaque*/
    int JS_ref; /*JS rflexe*/
    int JS_vig; /*JS vigueur*/
    int JS_vol; /*JS volont*/
    int PV; /*Points de vie*/
    int DV[5]; /*Nombre de DV*/
    char armure[255]; /*Armure*/
    char bouclier[255]; /*Bouclier*/
    char arme1[255]; /*Arme principale*/
    char arme2[255]; /*Arme secondaire*/
    char arme3[255]; /*Arme tertiaire*/
    int XP; /*Points d'XP rapport*/
    char don[50][100]; /*dons et arguments ventuels*/
    char competences[50][100]; /*Comptences et arguments ventuels*/
    int nivo_competences[50]; /*Level de chaque comptence*/
    int caracteristique[6]; /*Carac*/
    int bonus_carac[6]; /*Bonus carac*/
    char langue[30][100]; /*Langues parles*/
    char race[50]; /*Race*/
    char classe[50]; /*Classe de personnage*/
    char sexe[20]; /*Sexe*/
    char nom[255]; /*Nom (contenu dans le nom du fichier)*/
    char vision[100]; /*Mode de vision*/
    char chemin[4096];   /*Chemin de la feuille de perso*/
    char Traits_physiques[50][255]; /*Autres traits physiques*/
    char Capacite_spe[50][255]; /*Capacits spciales*/
    char Equipement[100][255]; /*Equipement*/
    char IMC[50];
    char cat_age[50];
    int nb_objets_magiques;
};

void Ph_jdr (const char* nomfichier);     /*Tire des phrases au hasard dans un fichier conu  cet effet*/
int* interpret_des (int *type, const char chaine_des[255], char chfunc[255]);      /*Retranscrit dans un tableau le nombre et le type de ds qui doivent tre lancs (type .d.)*/
char* color_sd (const char nomexe[255], char chfunc[255],char *argv[]);    /*Redtermine la couleur en fonction du fichier de config Couleurs.ini*/
void scan_feuille_perso (char nomfichier[4096], struct info_perso *perso);  /*Lit une feuille de perso au format txtp, et stocke ses info dans une structure info_perso*/
void saisie_feuille_perso (struct info_perso *perso); /*Demande l'ensemble des infos constituant la feuille de perso*/
void afficheur_struct_debug(struct info_perso *perso);  //Fonction de dbugage affichant l'ensemble de la structure perso

void Ph_jdr (const char* nomfichier)
{
    Init_srand();
    FILE* fichier;
    char chaine[255];
    int alea,i;
    fichier = ouvre_fichier (nomfichier,"r");
    fgets(chaine,255,fichier);
    for (i=0;i<(int)strlen(chaine);i++)
        chaine[i] = chaine[i+1];    /*Retire le d*/
    alea = NbAlea1b (atoi(chaine));   /*Lit la valeur du d et donne un valeur alatoire*/
    fgets(chaine,255,fichier);
    while (feof(fichier) == 0)
    {
        if (chaine[0] == '#')
        {
            for (i=0;i<(int)strlen(chaine);i++)
                chaine[i] = chaine[i+1];   /*Retire le #*/
            if (atoi(chaine) == alea)    /*Si le numro de phrase correspond  la valeur alatoire*/
            {
                while (isdigit(chaine[0]))
                {  /*Supprime les numros*/
                    for (i=0;i<(int)strlen(chaine);i++)
                        chaine[i] = chaine[i+1];
                }
                for (i=0;i<(int)strlen(chaine);i++)
                    chaine[i] = chaine[i+1]; /*Supprime l'espace*/
                while (chaine [0] != '#')
                {    /*recopie les lignes puis les affiche tant qu'il ne trouve pas un nouveau #*/
                    strcpy(chaine,acc(chaine,chfunc));
                    printf("%s",chaine);
                    fgets(chaine,255,fichier);
                }
                puts("");
                break;
            }
        }
        fgets(chaine,255,fichier);
    }
    fclose(fichier);
}

int* interpret_des (int *type, const char chaine_des[255], char chfunc[255])
{
    char saisi [255];
    int face, nb, taille=100, nbtotal=1, i;
    strcpy(saisi,chaine_des);
    if(chaine_des[0] == '0')     //Si saisi commence par 0, c'est que la chaine de ds n'a pas t donne au pralable, donc demande de saisie par l'utilisateur
        strcpy(saisi,nomajloc_des(chfunc));
    ER = (int) (type = (int*) calloc(taille,sizeof(int)));    /*Tableau contenant le nombre de face de chaque d  lancer*/
    Erreur(1);
    strcpy(chfunc,saisi);   //Copie la saisie dans chfunc pour les programmes dsirant garder en mmoire la saisie de l'utilisateur.
    while (strlen(saisi) > 0)
    {    /*Bcl jusqu' la fin de la chaine*/
        face = 0;    /*Valeur par dfaut*/
        nb = 0;      /*Valeur par dfaut*/
        nb = atoi(saisi);    /*Lit le nombre de d*/
        nbtotal += nb;        /*Augmente le total de ds*/
        while (isdigit(saisi[0]))
        {        /*Bcl en effaant les nombres*/
            for(i=0;i<(int)strlen(saisi);i++)
                saisi[i] = saisi[i+1];
        }
        for(i=0;i<(int)strlen(saisi);i++)      /*Efface le caractre qui spare les 2 valeur*/
            saisi[i] = saisi[i+1];
        face = atoi(saisi);   /*Lit le nombre de face pour les ds*/
        while (isdigit(saisi[0]))
        {        /*Bcl en effaant les nombres*/
            for(i=0;i<(int)strlen(saisi);i++)
                saisi[i] = saisi[i+1];
        }
        while (!(isdigit(saisi[0])))
        {        /*Efface les caractres qui spare les diffrents ds*/
            for(i=0;i<(int)strlen(saisi);i++)
                saisi[i] = saisi[i+1];
            if (strlen(saisi) == 0)
                break;
        }
        if (nbtotal > taille)
        {        /*Si le tableau est trop petit, agrandit*/
            taille += 100;
            ER = (int) (type = (int*) realloc(type,taille*sizeof(int)));
            Erreur(1);
        }
        for (i=nbtotal-nb;i<=nbtotal;i++)    /*Rempli le tableau, avec le nombre de face pour chaque d*/
            type[i] = face;
    }
    type[0] = nbtotal-1;    /*Inscrit, dans la 1ere case du tableau, le nb de d lu*/
    return (type);    /*Renvoi le tableau*/
}

char* color_sd (const char nomexe[255], char chfunc[255], char *argv[])
{
    FILE* fichier;
    char pwd[4096];
    #ifdef WIN32    //win
    strcpy(pwd,"Couleurs.ini");
    #else   //linux
    int tab[50];
    if(argv[0][0] == '/')
    {
        strcpy(pwd,argv[0]);
        pwd[tab[index_ch(pwd,"/",tab)-1]] = '\0';    //Termine la chaine au dernier / afin de supprimer l'executable
    }
    else
        getcwd(pwd,4000);   //pwd prend le chemin absolu de l'excutable
    strcat(pwd,"/");
    strcat(pwd,"Couleurs.ini");
    #endif
    fichier = ouvre_fichier(pwd,"r");
    do
    {
        fgets(chfunc,255,fichier);
    }while(strstr(chfunc,nomexe) == NULL);  //Cherche la ligne correpondant au nom du programme
    fgets(chfunc,255,fichier);
    #ifndef WIN32    /*pas win, donc linux*/
        fgets(chfunc,255,fichier);  //Prend la ligne suivante, la premire tant celle de DOS
    #endif
    Efface_n(chfunc);
    Efface_char(chfunc,":");    //Efface XTERM: ou DOS:
    fclose(fichier);
    return chfunc;  //Renvoi le couple de couleur
}

void scan_feuille_perso (char nomfichier[4096], struct info_perso *perso)
{
    FILE* feuille_perso;
    int i, j;
    int tab[50];
    char chaine[255];
    /*Lit le chemin du fichier de feuille de perso*/
    changeslash(nomfichier);
    if(strstr(nomfichier,"\\") != NULL || strstr(nomfichier,"/") != NULL)
    {
        #ifdef WIN32    //win
        if(strstr(nomfichier,"\\") != NULL) //Slash win
            i = index_ch(nomfichier,"\\",tab);
        #else   //linux
        if(strstr(nomfichier,"/") != NULL) //Slash linux
            i = index_ch(nomfichier,"/",tab);
        #endif
        strcpy(perso->chemin,nomfichier);
        perso->chemin[tab[i-1]+1] = '\0';     /*Termine la chaine aprs le dernier \*/
    }
    else
        perso->chemin[0] = '\0'; /*Chaine vide si pas de chemin*/
    feuille_perso = ouvre_fichier(nomfichier,"r");
/*    Lit le nom du perso*/
    fgets(chaine,255,feuille_perso);    /*Lit le nom du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    strcpy(perso->nom,chaine); /*Stocke la valeur lue*/
/*    Lit la classe du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit la classe de perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    strcpy(perso->classe,chaine); /*Stocke la valeur lue*/
/*    Lit le niveau du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le niveau du perso*/
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    perso->niveau = atoi(chaine); /*Stocke la valeur lue*/
/*    Lit la race du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "Traits physiques:"*/
    fgets(chaine,255,feuille_perso);    /*Lit la race du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    strcpy(perso->race,chaine); /*Stocke la valeur lue*/
/*    Lit le sexe du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le sexe du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    strcpy(perso->sexe,chaine); /*Stocke la valeur lue*/
/*    Lit le poids du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le poids du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    perso->poids = atoi(chaine); /*Stocke la valeur lue*/
    Efface_char(chaine,"g");
    strcpy(perso->IMC,chaine);
/*    Lit la taille du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit la taille du perso*/
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    perso->taille = atoi(chaine); /*Stocke la valeur lue*/
    Efface_char(chaine,"(");
    strcpy(perso->cat_taille,chaine);   /*Copie la catgorie de taille*/
    i=0;
    while(perso->cat_taille[i++] != ')');   //Parcours jusqu' la paranthse fermante
    perso->cat_taille[i-1] = '\0';    //Tronque sur la parenthse
/*    Lit l'ge du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit l'ge du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    perso->age = atoi(chaine); /*Stocke la valeur lue*/
    Efface_char(chaine,"s");
    strcpy(perso->cat_age,chaine);
/*    Lit les autres traits physiques du personnage*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        Efface_n(chaine);
        strcpy(perso->Traits_physiques[i],chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->Traits_physiques[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*    Lit les caractristiques et les bonus associs du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "Caractristiques:"*/
    for(i=0;i<6;i++)
    {
        fgets(chaine,255,feuille_perso);    /*Lit la carac du perso*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        perso->caracteristique[i] = atoi(chaine); /*Stocke la valeur de carac lue*/
        Efface_char(chaine,"(");    /*Efface la parenthse*/
        j=1;
        if(chaine[0] == '-')
        {
            j = -1; /*Si le bonus est ngatif, la valeur sera rendu ngative*/
            Efface_char(chaine,"-");
        }
        else
            Efface_char(chaine,"+");
        perso->bonus_carac[i] = atoi(chaine); /*Stocke le modif associ  la carac*/
        perso->bonus_carac[i] *= j; /*Rend la valeur ventuellement ngative*/
    }
/*    Lit le mode de vision du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le mode de vision du perso*/
    Efface_n(chaine);
    strcpy(perso->vision,chaine); /*Stocke la valeur lue*/
/*    Lit l'alignement du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit l'alignement du perso*/
    Efface_n(chaine);
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    strcpy(perso->alignement,chaine); /*Stocke la valeur lue*/
/*    Lit les jets d'attaques du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit les jets d'attaque du perso*/
    Efface_char(chaine,"+");    /*Efface le texte avant le premier +*/
    j = index_ch(chaine,"\\",perso->attaque); /*Donne le nombre de \ dans la chaine (soit le nombre de jet d'attaque-1) et stocke dans j. attaque est utilis pour la fonction, mais ne sert  rien ici*/
    perso->attaque[0] = j; /*La premire valeur du tableau est le nombre d'attaque*/
    perso->attaque[1] = atoi(chaine);
    for(i=2;i<j+2;i++)
    {
        Efface_char(chaine,"+"); /*Coupe jusqu'au jet d'attaque suivant*/
        perso->attaque[i] = atoi(chaine);
    }
/*    Lit le jet de sauvegarde rflexe du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "Jet de sauvegarde:"*/
    fgets(chaine,255,feuille_perso);    /*Lit le JS ref du perso*/
    Efface_char(chaine,"+");    /*Efface le texte avant +*/
    perso->JS_ref = atoi(chaine); /*Stocke la valeur lue*/
/*    Lit le jet de sauvegarde vigueur du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le JS ref du perso*/
    Efface_char(chaine,"+");    /*Efface le texte vig +*/
    perso->JS_vig = atoi(chaine); /*Stocke la valeur lue*/
/*    Lit le jet de sauvegarde volont du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit le JS vol du perso*/
    Efface_char(chaine,"+");    /*Efface le texte avant +*/
    perso->JS_vol = atoi(chaine); /*Stocke la valeur lue*/
/*    Lit les points de vie du personnage*/
    fgets(chaine,255,feuille_perso);    /*Lit les PV du perso*/
    Efface_char(chaine,":");
    Efface_char(chaine," ");    /*Efface le texte avant : */
    perso->PV = atoi(chaine); /*Stocke la valeur lue*/
    Efface_char(chaine,"=");
    perso->DV[0] = atoi(chaine);   /*Copie le nb de ds de vie raciaux*/
    if(perso->DV[0] > 0)    //Si DV raciaux
    {
        Efface_char(chaine,"d");
        perso->DV[1] = atoi(chaine);   /*Copie le nb de face des ds de vie raciaux*/
    }
    Efface_char(chaine,"+");
    perso->DV[2] = atoi(chaine);   /*Copie le nb de ds de vie de classe*/
    Efface_char(chaine,"d");
    perso->DV[3] = atoi(chaine);   /*Copie le nb de face des ds de vie de classe*/
    Efface_char(chaine,"+");
    perso->DV[4] = atoi(chaine);   /*Copie le bonus au PV*/
/*    Lit l'armure du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saisi la premire ligne*/
    Efface_n(chaine);
    strcpy(perso->armure,">"); /*Stocke un >  la place pour indiquer qu'il n'y a rien, le cas chant*/
    if(strstr(chaine,"Armure:") != NULL)
    {   /*Le perso possde une armure*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        strcpy(perso->armure,chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
        Efface_n(chaine);
    }
/*    Lit l'arme principale du personnage*/
    strcpy(perso->arme1,">"); /*Stocke un >  la place pour indiquer qu'il n'y a rien, le cas chant*/
    if(strstr(chaine,"Arme principale:") != NULL)
    {   /*Le perso possde une arme principale*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        strcpy(perso->arme1,chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
        Efface_n(chaine);
    }
/*    Lit l'arme secondaire du personnage*/
    strcpy(perso->arme2,">"); /*Stocke un >  la place pour indiquer qu'il n'y a rien, le cas chant*/
    if(strstr(chaine,"Arme secondaire:") != NULL)
    {   /*Le perso possde une arme secondaire*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        strcpy(perso->arme2,chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
        Efface_n(chaine);
    }
/*    Lit l'arme tertiaire du personnage*/
    strcpy(perso->arme3,">"); /*Stocke un >  la place pour indiquer qu'il n'y a rien, le cas chant*/
    if(strstr(chaine,"Arme tertiaire:") != NULL)
    {   /*Le perso possde une arme tertiaire*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        strcpy(perso->arme3,chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
        Efface_n(chaine);
    }
/*    Lit le bouclier du personnage*/
    strcpy(perso->bouclier,">"); /*Stocke un >  la place pour indiquer qu'il n'y a rien, le cas chant*/
    if(strstr(chaine,"Bouclier:") != NULL)
    {   /*Le perso possde un bouclier*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        strcpy(perso->bouclier,chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
        Efface_n(chaine);
    }
/*    Lit les langues connues par le personnage*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        Efface_n(chaine);
        strcpy(perso->langue[i],chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->langue[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*    Lit les dons du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "Dons:"*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        Efface_n(chaine);
        strcpy(perso->don[i],chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->don[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*    Lit les comptences du personnage et leur niveau respectif*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "Comptences:"*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        j=0;
        do
        {   /*Copie la comptence jusqu'au +*/
            perso->competences[i][j] = chaine[j];
            j++;
        }while(chaine[j] != '+');
        Efface_char(chaine,"+"); /*Efface jusqu'au +, pour garder que le niveau*/
        perso->nivo_competences[i] = atoi(chaine); /*Prend la niveau correspondant de la comptence*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->competences[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*    Lit l'XP rapport par le personnage*/
    perso->XP = -1; /*Stocke -1  la place pour indiquer qu'il n'y a rien, le cas chant*/
    fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
    if(strstr(chaine,"objets magiques  dterminer.") != NULL)
        perso->nb_objets_magiques = atoi(chaine);
        fgets(chaine,255,feuille_perso);
    if(strstr(chaine,"Points d'exprience:") != NULL)
    {   /*Le perso a une indication de l'XP qu'il rapporte*/
        Efface_char(chaine,":");
        Efface_char(chaine," ");    /*Efface le texte avant : */
        perso->XP = atoi(chaine); /*Lit la valeur d'XP*/
        fgets(chaine,255,feuille_perso);    /*Saisi la ligne suivante*/
    }
/*    Lit les capacits spciales du personnage*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        Efface_n(chaine);
        strcpy(perso->Capacite_spe[i],chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->Capacite_spe[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*    Lit l'quipement du personnage*/
    fgets(chaine,255,feuille_perso);    /*Saute la ligne "#Equipements:"*/
    fgets(chaine,255,feuille_perso);    /*Prend la premire ligne*/
    i=0;
    while(chaine[0] != '>')
    {
        Efface_n(chaine);
        strcpy(perso->Equipement[i],chaine); /*Stocke la valeur lue*/
        fgets(chaine,255,feuille_perso);    /*Prend la ligne suivante*/
        i++; /*Passe  la chaine suivante dans le tableau*/
    }
    strcpy(perso->Equipement[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
    fclose(feuille_perso);
}

void afficheur_struct_debug(struct info_perso *perso)
{
    int i;
    char chaine[255];
    printf("\nNom: %s\n", perso->nom);
    printf("Classe de personnage: %s\n", perso->classe);
    printf("Niveau: %d\n", perso->niveau);
    printf("Traits physiques:\n");
    printf(" Race: %s\n", perso->race);
    printf(" Sexe: %s\n", perso->sexe);
    printf(" Poids: %dKg%s\n", perso->poids, perso->IMC);
    printf(" Taille: %dcm (%s)\n", perso->taille, perso->cat_taille);
    printf(" Age: %d ans%s\n", perso->age, perso->cat_age);
    i=0;
    while(perso->Traits_physiques[i][0] != '>')
    {
        printf("%s\n", perso->Traits_physiques[i]);
        i++;
    }
    printf(">\nCaractristiques:\n");
    printf("Force: %d", perso->caracteristique[0]);
    if (perso->bonus_carac[0] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[0]);
    else
        printf(" (+%d)\n", perso->bonus_carac[0]);
    printf("Dextrit: %d", perso->caracteristique[1]);
    if (perso->bonus_carac[1] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[1]);
    else
        printf(" (+%d)\n", perso->bonus_carac[1]);
    printf("Constitution: %d", perso->caracteristique[2]);
    if (perso->bonus_carac[2] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[2]);
    else
        printf(" (+%d)\n", perso->bonus_carac[2]);
    printf("Intelligence: %d", perso->caracteristique[3]);
    if (perso->bonus_carac[3] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[3]);
    else
        printf(" (+%d)\n", perso->bonus_carac[3]);
    printf("Sagesse: %d", perso->caracteristique[4]);
    if (perso->bonus_carac[4] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[4]);
    else
        printf(" (+%d)\n", perso->bonus_carac[4]);
    printf("Charisme: %d", perso->caracteristique[5]);
    if (perso->bonus_carac[5] < 0) /*Si bonus ngatif*/
        printf(" (%d)\n", perso->bonus_carac[5]);
    else
        printf(" (+%d)\n", perso->bonus_carac[5]);
    printf("%s",perso->vision);
    printf("\nAlignement: %s\n", perso->alignement);
    printf("Jet d'attaque: +%d", perso->attaque[1]);
    for(i=2;i<perso->attaque[0]+2;i++)
        printf("\\+%d", perso->attaque[i]);
    printf("\nJet de sauvegarde:\n");
    printf(" Rflexe: +%d\n", perso->JS_ref);
    printf(" Vigueur: +%d\n", perso->JS_vig);
    printf(" Volont: +%d\n", perso->JS_vol);
    printf("Points de vie: %d (DV=%d", perso->PV, perso->DV[0]);
    if(perso->DV[0] > 0)
        printf("d%d", perso->DV[1]);
    printf("+%dd%d+%d)\n", perso->DV[2], perso->DV[3], perso->DV[4]);
    if (perso->armure[0] != '>')
        printf("Armure: %s\n", perso->armure);
    if (perso->arme1[0] != '>')
        printf("Arme principale: %s\n", perso->arme1);
    if (perso->arme2[0] != '>')
        printf("Arme secondaire: %s\n", perso->arme2);
    if (perso->arme3[0] != '>')
        printf("Arme tertiaire: %s\n", perso->arme3);
    i=0;
    while(perso->Capacite_spe[i][0] != '>')
    {
        if(strstr(perso->Capacite_spe[i++],"#attsup.") != NULL)   //Si c'est une attaque supplmentaire
        {
            strcpy(chaine,perso->Capacite_spe[i-1]);
            Efface_char(chaine,".");
            printf("Attaque supplmentaire: %s\n", chaine);
        }
    }
    if (perso->bouclier[0] != '>')
        printf("Bouclier: %s\n", perso->bouclier);
    i=0;
    printf("Langues parles:\n");
    while(perso->langue[i][0] != '>')
        printf("%s\n", perso->langue[i++]);
    printf(">\nDons:\n");
    i=0;
    while(perso->don[i][0] != '>')
        printf("%s\n", perso->don[i++]);
    printf(">\nComptences:\n");
    i=0;
    while(perso->competences[i][0] != '>')
    {
        if(strstr(perso->competences[i],"!!! Il reste ") != NULL)   //Reste x points  rpartir, affichage sans bonus comp!
            printf("%s\n", perso->competences[i]);
        else
            printf("%s +%d\n", perso->competences[i], perso->nivo_competences[i]);
        i++;
    }
    printf(">\n%d objets magiques  dterminer.\n", perso->nb_objets_magiques);
    printf("Points d'exprience: %d\n", perso->XP);
    printf("Capacits spciales:\n");
    i=0;
    while(perso->Capacite_spe[i][0] != '>')
    {
        if(strstr(perso->Capacite_spe[i++],"#attsup.") == NULL)   //Si c'est pas une attaque supplmentaire, affiche en cap sp
            printf("%s\n", perso->Capacite_spe[i-1]);
    }
    printf(">\n#Equipements:\n");
    i=0;
    while(perso->Equipement[i][0] != '>')
        printf("%s\n", perso->Equipement[i++]);
    printf(">\n");
}

void saisie_feuille_perso (struct info_perso *perso)
{
    char chaine[255];
    int i, j;
    putsacc("En l'absence de feuille de personnage au format txtp, il faut entrer toutes les caractristiques du personnage.\n\n");
/*Nom du perso*/
    printf("Nom: ");
    getsfix(perso->nom,255);            /*Lit la rponse de l'utilisateur*/
/*Classe du perso*/
    printf("Classe: ");
    getsfix(perso->classe,50);            /*Lit la rponse de l'utilisateur*/
/*Niveau du perso*/
    do
    {    /*Boucle d'erreur de saisie*/
        printf("Niveau: ");
        perso->niveau = (int) interpret_calc("\0");
    } while (perso->niveau == NA || perso->niveau == defo);
/*Race du perso*/
    printf("Race: ");
    getsfix(perso->race,50);            /*Lit la rponse de l'utilisateur*/
/*Sexe du perso*/
    printf("Sexe: ");
    getsfix(perso->sexe,20);            /*Lit la rponse de l'utilisateur*/
/*Poids du perso*/
    printf("Poids (en Kg): ");
    getsfix(chaine,255);            /*Lit la rponse de l'utilisateur*/
    perso->poids = atoi(chaine);
/*Taille du perso*/
    printf("Taille (en cm): ");
    getsfix(chaine,255);            /*Lit la rponse de l'utilisateur*/
    perso->taille = atoi(chaine);
    putsacc("Catgorie de taille: ");
    getsfix(perso->cat_taille,10);            /*Lit la rponse de l'utilisateur*/
/*Age du perso*/
    printf("Age: ");
    getsfix(chaine,255);            /*Lit la rponse de l'utilisateur*/
    perso->age = atoi(chaine);
/*Traits physiques du perso*/
    putsacc("Traits physiques: (Un appui sur entre permet de sparer les diffrents traits\nphysiques. Terminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->Traits_physiques[i++],chaine);
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->Traits_physiques[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*Caractristiques*/
    for(i=0;i<6;i++)
    {
        do
        {    /*Boucle d'erreur de saisie*/
            if(i==0)
                printf("Force: ");
            if(i==1)
                putsacc("Dextrit: ");
            if(i==2)
                printf("Constitution: ");
            if(i==3)
                printf("Intelligence: ");
            if(i==4)
                printf("Sagesse: ");
            if(i==5)
                printf("Charisme: ");
            perso->caracteristique[i] = (int) interpret_calc("\0");
        } while (perso->caracteristique[i] == NA || perso->caracteristique[i] == defo);
        /*Dtermine le modificateur de carac*/
        if(perso->caracteristique[i] < 10)
            perso->bonus_carac[i] = (perso->caracteristique[i]-11)/2;
        else
            perso->bonus_carac[i] = (perso->caracteristique[i]-10)/2;
    }
/*Mode de vision*/
    printf("Type de vision: ");
    getsfix(perso->vision,100);            /*Lit la rponse de l'utilisateur*/
/*Alignement*/
    printf("Alignement: ");
    getsfix(perso->alignement,50);            /*Lit la rponse de l'utilisateur*/
/*Jets d'attaques*/
    putsacc("Jets d'attaques (Sparer par les diffrentes valeur par \\. Ex: +6\\+1): +");
    getsfix(chaine,255);            /*Lit la rponse de l'utilisateur*/
    for(i=0;i<(int)strlen(chaine);i++)
    {   /*Remplace les / par des \*/
        if(chaine[i] == '/')
            chaine[i] = '\\';
    }
    j = index_ch(chaine,"\\",perso->attaque); /*Donne le nombre de \ dans la chaine (soit le nombre de jet d'attaque-1) et stocke dans j. attaque est utilis pour la fonction, mais ne sert  rien ici*/
    perso->attaque[0] = j; /*La premire valeur du tableau est le nombre d'attaque*/
    perso->attaque[1] = atoi(chaine);
    for(i=2;i<j+2;i++)
    {
        Efface_char(chaine,"+"); /*Coupe jusqu'au jet d'attaque suivant*/
        perso->attaque[i] = atoi(chaine);
    }
/*Rflexe*/
    do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Jet de sauvegarde rflexe: +");
        perso->JS_ref = (int) interpret_calc("\0");
    } while (perso->JS_ref == NA || perso->JS_ref == defo);
/*Vigueur*/
    do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Jet de sauvegarde vigueur: +");
        perso->JS_vig = (int) interpret_calc("\0");
    } while (perso->JS_vig == NA || perso->JS_vig == defo);
/*Volont*/
    do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Jet de sauvegarde volont: +");
        perso->JS_vol = (int) interpret_calc("\0");
    } while (perso->JS_vol == NA || perso->JS_vol == defo);
/*PV*/
    do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Points de vie: ");
        perso->PV = (int) interpret_calc("\0");
    } while (perso->PV == NA || perso->PV == defo);
    do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Ds de vie raciaux (.d.): ");
        strcpy(chaine,nomajloc_des(chfunc));
    } while (strstr(chaine,"d") == NULL && chaine[0] != 0);  //Bcl d'erreur tant qu'il ne trouve pas d et que c'est pas 0 au dbut.
    perso->DV[0] = atoi(chaine);   /*Copie le nb de ds de vie raciaux*/
    if(perso->DV[0] > 0)    //Si DV raciaux
    {
        Efface_char(chaine,"d");
        perso->DV[1] = atoi(chaine);   /*Copie le nb de face des ds de vie raciaux*/
    }
        do
    {    /*Boucle d'erreur de saisie*/
        putsacc("Ds de vie de classe (.d.): ");
        strcpy(chaine,nomajloc_des(chfunc));
    } while (strstr(chaine,"d") == NULL);
    perso->DV[2] = atoi(chaine);   /*Copie le nb de ds de vie de classe*/
    Efface_char(chaine,"d");
    perso->DV[3] = atoi(chaine);   /*Copie le nb de face des ds de vie de classe*/
/*Armure*/
    printf("Armure: ");
    getsfix(perso->armure,255);            /*Lit la rponse de l'utilisateur*/
/*Arme principale*/
    printf("Arme principale: ");
    getsfix(perso->arme1,255);            /*Lit la rponse de l'utilisateur*/
/*Arme secondaire*/
    printf("Arme secondaire: ");
    getsfix(perso->arme2,255);            /*Lit la rponse de l'utilisateur*/
/*Arme tertiaire*/
    printf("Arme tertiaire: ");
    getsfix(perso->arme3,255);            /*Lit la rponse de l'utilisateur*/
/*Bouclier*/
    printf("Bouclier: ");
    getsfix(perso->bouclier,255);            /*Lit la rponse de l'utilisateur*/
/*Langues connues*/
    putsacc("Langues connues: (Un appui sur entre permet de sparer les diffrentes langues. Terminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->langue[i++],chaine);
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->langue[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*Dons*/
    putsacc("Liste des dons: (Un appui sur entre permet de sparer les diffrents dons.\nTerminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->don[i++],chaine);
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->don[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*Comptences*/
    putsacc("Liste des comptences: (Un appui sur entre permet de sparer les diffrentes\ncomptences. Terminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->competences[i],chaine);
        /*Niveau de la comptence*/
        do
        {    /*Boucle d'erreur de saisie*/
            printf("Niveau, %s +", acc(perso->competences[i],chfunc));
            perso->nivo_competences[i] = (int) interpret_calc("\0");
        } while (perso->nivo_competences[i] == NA || perso->nivo_competences[i] == defo);
        i++;
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->competences[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*XP*/
    putsacc("XP rapport par le personnage s'il est vaincu: ");
    getsfix(chaine,255);            /*Lit la rponse de l'utilisateur*/
    perso->XP = atoi(chaine);
/*Capacit spciales*/
    putsacc("Capacits spciales: (Un appui sur entre permet de sparer les diffrentes\ncapacit spciales. Terminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->Capacite_spe[i++],chaine);
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->Capacite_spe[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
/*Equipements*/
    putsacc("Equipement: (Un appui sur entre permet de sparer les diffrents lments de\nl'quipement. Terminer la saisie par le terme fin)\n?: ");
    getsfix(chaine,255);            /*Lit la premire saisie de l'utilisateur*/
    i=0;
    while(strcmp(chaine,"fin") != 0 && strcmp(chaine,"Fin") != 0 && strcmp(chaine,"FIN") != 0)
    {
        strcpy(perso->Equipement[i++],chaine);
        printf("?: ");
        getsfix(chaine,255);            /*Lit la saisie de l'utilisateur*/
    }
    strcpy(perso->Equipement[i],">"); /*Stocke un > dans la ligne suivante, afin de marquer la fin de liste*/
}

#endif
